/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.capabilities.IExtendedEntity;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityFear;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.network.MessageEntityPickedUp;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;

public class ExtendedEntity
implements IExtendedEntity {
    public static Map<Entity, ExtendedEntity> clientExtendedEntities = new HashMap<Entity, ExtendedEntity>();
    public static String[] FORCE_REMOVE_ENTITY_IDS;
    public static int FORCE_REMOVE_ENTITY_TICKS;
    public EntityLivingBase entity;
    Vector3d lastSafePos;
    private boolean playerAllowFlyingSnapshot;
    private boolean playerIsFlyingSnapshot;
    public Entity pickedUpByEntity;
    private int pickedUpByEntityID;
    public EntityFear fearEntity;
    boolean forceRemoveChecked = false;
    boolean forceRemove = false;
    int forceRemoveTicks = FORCE_REMOVE_ENTITY_TICKS;

    public static ExtendedEntity getForEntity(EntityLivingBase entity) {
        if (entity == null) {
            return null;
        }
        if (entity.field_70170_p != null && entity.field_70170_p.field_72995_K) {
            if (clientExtendedEntities.containsKey(entity)) {
                ExtendedEntity extendedEntity = clientExtendedEntities.get(entity);
                extendedEntity.setEntity(entity);
                return extendedEntity;
            }
            ExtendedEntity extendedEntity = new ExtendedEntity();
            extendedEntity.setEntity(entity);
            clientExtendedEntities.put((Entity)entity, extendedEntity);
        }
        IExtendedEntity iExtendedEntity = null;
        try {
            iExtendedEntity = (IExtendedEntity)entity.getCapability(LycanitesMobs.EXTENDED_ENTITY, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (iExtendedEntity == null || !(iExtendedEntity instanceof ExtendedEntity)) {
            return null;
        }
        ExtendedEntity extendedEntity = (ExtendedEntity)iExtendedEntity;
        if (extendedEntity.getEntity() != entity) {
            extendedEntity.setEntity(entity);
        }
        return extendedEntity;
    }

    public void setEntity(EntityLivingBase entity) {
        this.entity = entity;
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public void onUpdate() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.field_70170_p != null && !this.entity.field_70170_p.field_72995_K && FORCE_REMOVE_ENTITY_IDS != null && FORCE_REMOVE_ENTITY_IDS.length > 0 && !this.forceRemoveChecked) {
            LycanitesMobs.printDebug("ForceRemoveEntity", "Forced entity removal, checking: " + this.entity.func_70005_c_());
            for (String forceRemoveID : FORCE_REMOVE_ENTITY_IDS) {
                if (!forceRemoveID.equalsIgnoreCase(this.entity.func_70005_c_())) continue;
                this.forceRemove = true;
                break;
            }
            this.forceRemoveChecked = true;
        }
        if (this.forceRemove && this.forceRemoveTicks-- <= 0) {
            this.entity.func_70106_y();
        }
        if (this.entity.func_130014_f_() != null) {
            if (this.lastSafePos == null) {
                this.lastSafePos = new Vector3d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v);
            }
            if (!this.entity.func_130014_f_().func_180495_p(this.entity.func_180425_c()).func_185904_a().func_76220_a()) {
                this.lastSafePos.set(Math.floor(this.entity.field_70165_t) + 0.5, (double)this.entity.func_180425_c().func_177956_o(), Math.floor(this.entity.field_70161_v) + 0.5);
            }
        }
        if (this.fearEntity != null && !this.fearEntity.func_70089_S()) {
            this.fearEntity = null;
        }
        this.updatePickedUpByEntity();
    }

    public void onDeath() {
        this.setPickedUpByEntity(null);
    }

    public void updatePickedUpByEntity() {
        if (this.pickedUpByEntity == null || this.entity.func_130014_f_() == null) {
            return;
        }
        if (!this.pickedUpByEntity.func_70089_S()) {
            this.setPickedUpByEntity(null);
            return;
        }
        if (this.pickedUpByEntity instanceof EntityLivingBase && ((EntityLivingBase)this.pickedUpByEntity).func_110143_aJ() <= 0.0f) {
            this.setPickedUpByEntity(null);
            return;
        }
        if (ObjectManager.getPotionEffect("weight") != null && this.entity.func_70644_a((Potion)ObjectManager.getPotionEffect("weight"))) {
            this.setPickedUpByEntity(null);
            return;
        }
        if (this.entity.func_70068_e(this.pickedUpByEntity) > 32.0) {
            this.setPickedUpByEntity(null);
            return;
        }
        double[] pickupOffset = this.getPickedUpOffset();
        this.entity.func_70107_b(this.pickedUpByEntity.field_70165_t + pickupOffset[0], this.pickedUpByEntity.field_70163_u + pickupOffset[1], this.pickedUpByEntity.field_70161_v + pickupOffset[2]);
        this.entity.field_70159_w = this.pickedUpByEntity.field_70159_w;
        this.entity.field_70181_x = this.pickedUpByEntity.field_70181_x;
        this.entity.field_70179_y = this.pickedUpByEntity.field_70179_y;
        this.entity.field_70143_R = 0.0f;
        if (!this.entity.func_130014_f_().field_72995_K && this.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.entity;
            player.field_71075_bZ.field_75101_c = true;
            this.entity.field_70145_X = true;
        }
        if (!this.entity.func_70089_S()) {
            this.setPickedUpByEntity(null);
        }
        if (this.entity instanceof EntityLivingBase && this.entity.func_110143_aJ() <= 0.0f) {
            this.setPickedUpByEntity(null);
        }
    }

    public void setPickedUpByEntity(Entity pickedUpByEntity) {
        if (this.pickedUpByEntity == pickedUpByEntity || this.entity == null) {
            return;
        }
        if (this.entity.func_184187_bx() != null) {
            this.entity.func_184210_p();
        }
        this.pickedUpByEntity = pickedUpByEntity;
        if (!this.entity.field_70170_p.field_72995_K) {
            if (this.entity instanceof EntityPlayer) {
                if (pickedUpByEntity != null) {
                    this.playerAllowFlyingSnapshot = ((EntityPlayer)this.entity).field_71075_bZ.field_75101_c;
                    this.playerIsFlyingSnapshot = ((EntityPlayer)this.entity).field_71075_bZ.field_75100_b;
                } else {
                    ((EntityPlayer)this.entity).field_71075_bZ.field_75101_c = this.playerAllowFlyingSnapshot;
                    ((EntityPlayer)this.entity).field_71075_bZ.field_75100_b = this.playerIsFlyingSnapshot;
                    this.entity.field_70145_X = false;
                }
            }
            if (this.pickedUpByEntity != null && !(this.entity instanceof EntityPlayer)) {
                double[] pickupOffset = this.getPickedUpOffset();
                this.entity.func_184595_k(this.pickedUpByEntity.field_70165_t + pickupOffset[0], this.pickedUpByEntity.field_70163_u + pickupOffset[1], this.pickedUpByEntity.field_70161_v + pickupOffset[2]);
            }
            MessageEntityPickedUp message = new MessageEntityPickedUp((Entity)this.entity, pickedUpByEntity);
            LycanitesMobs.packetHandler.sendToDimension(message, this.entity.field_71093_bK);
        }
        if (pickedUpByEntity == null) {
            if (this.lastSafePos != null) {
                this.entity.func_70107_b(this.lastSafePos.getX(), this.lastSafePos.getY(), this.lastSafePos.getZ());
            }
            this.entity.field_70159_w = 0.0;
            this.entity.field_70181_x = 0.0;
            this.entity.field_70179_y = 0.0;
            this.entity.field_70143_R = 0.0f;
        }
    }

    public double[] getPickedUpOffset() {
        double[] pickupOffset = new double[]{0.0, 0.0, 0.0};
        if (this.pickedUpByEntity instanceof EntityCreatureBase) {
            pickupOffset = ((EntityCreatureBase)this.pickedUpByEntity).getPickupOffset((Entity)this.entity);
        }
        if (MobInfo.disablePickupOffsets && this.entity instanceof EntityPlayer) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return pickupOffset;
    }

    public boolean isPickedUp() {
        return this.pickedUpByEntity != null;
    }

    public boolean isFeared() {
        return this.pickedUpByEntity instanceof EntityFear;
    }

    public void readNBT(NBTTagCompound nbtTagCompound) {
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
    }

    static {
        FORCE_REMOVE_ENTITY_TICKS = 40;
    }
}

